unit ucAddProduct;

interface

uses System.Data, System.Drawing, System.Web, System.Web.UI, System.Collections, Borland.Data.Provider,Borland.Data.Common,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls, System.IO, System.Text;

type
  TAction = (ProductAdd, ProductUpdate);
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucAddProduct = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure AddProductButton_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dlSubMenu: System.Web.UI.WebControls.DataList;
    ModelNameTextBox: System.Web.UI.WebControls.TextBox;
    ModelNameRequired: System.Web.UI.WebControls.RequiredFieldValidator;
    cboCategory: System.Web.UI.WebControls.DropDownList;
    ModelNumberTextBox: System.Web.UI.WebControls.TextBox;
    ModelNumberRequired: System.Web.UI.WebControls.RequiredFieldValidator;
    UnitCostTextBox: System.Web.UI.WebControls.TextBox;
    UnitCostTextBoxRequired: System.Web.UI.WebControls.RequiredFieldValidator;
    DescriptionTextBox: System.Web.UI.WebControls.TextBox;
    AddProductButton: System.Web.UI.WebControls.Button;
    ProductImage: System.Web.UI.WebControls.Image;
    pnlImage: System.Web.UI.WebControls.Panel;
    ErrorMessage: System.Web.UI.WebControls.Label;
    lblAddorEdit: System.Web.UI.WebControls.Label;

    ImageFile : System.Web.UI.HtmlControls.HtmlInputFile;
    chkRemoveImage: System.Web.UI.WebControls.CheckBox;
    procedure OnInit(e: System.EventArgs); override;
  private
    OldImageFileName : string;
    Action : TAction;
    PID : integer;
    procedure BindSubMenu;
    procedure FillCategories;
    function BindForUpdate : boolean;
    function GetCategoryEditIndex(const CatID : integer) : integer;
    procedure SetupForAdding;
    function DoUploadImage (var FileSavedName, ErrorMessage : string; const OldImageName : string; const RemoveExistingImage : boolean):boolean;
    procedure GenerateThumbNail(const FileName : string; const ImageStream : Stream; const tWidth, tHeight : Double);
    function NewThumbSize(const currentwidth, currentheight, newWidth, newHeight : Double) : Size;
  public
    { Public Declarations }
  end;

implementation

uses Helper, HelperDB;

procedure TucAddProduct.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  if not Page.IsPostback then
  begin
    FillCategories;
    BindSubMenu;
  end;

  if (Assigned(Page.Request.Params['pid']))  AND (Page.Request.Params['pid'] <> '') then
  begin
    Action := ProductUpdate;
    try
      PID := Convert.ToInt32(Page.Request.Params['pid']);
      pnlImage.Visible:=True;
      if not BindForUpdate then
        SetupForAdding
      else
      begin
        cboCategory.Items.RemoveAt(0);
        cboCategory.Items.Insert(0, ListItem.Create('-- Move to category --','-1'));

        lblAddorEdit.Text:='UPDATE PRODUCT "' + Server.HtmlEncode(ModelNameTextBox.Text) +'"';
        AddProductButton.Text := 'Update in database'
      end;
    except
      ErrorMessage.Text := 'Bad input!';
      SetupForAdding
    end;
  end
  else
  begin
    SetupForAdding;
  end;

end;

procedure TucAddProduct.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucAddProduct.InitializeComponent;
begin
  Include(Self.AddProductButton.Click, Self.AddProductButton_Click);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucAddProduct.BindSubMenu;
var
  al : ArrayList;
begin
  al := ArrayList.Create;

  al.Add(TLinkList.Create('EDIT PRODUCTS', 'default.aspx?action=products'));

  dlSubMenu.DataSource := al;
  dlSubMenu.DataBind();
end;

procedure TucAddProduct.FillCategories;
var
  ctext : string;
	cvalue : string;
  ds : DataSet;
begin
  ds := THelperDB.FillDataset('SELECT CategoryID, CategoryName FROM Categories');
  cboCategory.DataSource :=  ds;

  ctext := ds.Tables[0].Columns[1].ToString();
  cvalue := ds.Tables[0].Columns[0].ToString();

  cboCategory.DataTextField := ctext;
  cboCategory.DataValueField := cvalue;
  cboCategory.DataBind();
  cboCategory.Items.Insert(0, ListItem.Create('-- Select category --','-1'));
  cboCategory.SelectedIndex := 0;
end;

function TucAddProduct.BindForUpdate : boolean;
var
  dr: BDPDataReader;
  CatID : integer;
begin
  dr:= THelperDB.FillReader('SELECT * FROM Products WHERE ProductID = ' + PID.toString);

  CatID := -1;
  Result:=False;

  while dr.Read do
  begin
    Result:=True;

    CatID := Convert.ToInt32(dr.Item['CategoryID']);
    ModelNameTextBox.Text:= Server.HtmlDecode(dr.Item['ModelName'].ToString);
    ModelNumberTextBox.Text:= Server.HtmlDecode(dr.Item['ModelNumber'].ToString);
    UnitCostTextBox.Text := System.String.Format('{0:c}', dr.Item['UnitCost'].ToString);
    DescriptionTextBox.Text := Server.HtmlDecode(dr.Item['Description'].ToString);
    if dr.Item['ProductImage'].ToString <> '' then
    begin
      ProductImage.ImageUrl := THelper.VirtualImagePath + dr.Item['ProductImage'].ToString;
      OldImageFileName := THelper.ImagesPath + dr.Item['ProductImage'].ToString;
      ViewState['OldImageFileName'] := OldImageFileName;
    end
    else
    begin
      pnlImage.Visible := False;
      OldImageFileName := '';
    end;
  end;

  cboCategory.SelectedIndex := 1 + GetCategoryEditIndex(CatID);
end;

function TucAddProduct.GetCategoryEditIndex(const CatID: integer): integer;
var
  dt : DataTable;
  i : integer;
begin
  Result := 0;

  dt:= THelperDB.FillDataset('SELECT CategoryID FROM Categories').Tables[0];
  for i := 0 to -1 + dt.Rows.Count do
  begin
    if Convert.ToInt32(dt.Rows[i]['CategoryID']) = CatID then
    begin
      Result := i;
      Break;
    end;
  end;
end;

procedure TucAddProduct.SetupForAdding;
begin
  Action := ProductAdd;
  lblAddorEdit.Text:='ADD NEW PRODUCT';
  pnlImage.Visible:=False;
  PID := -1;
end;

procedure TucAddProduct.AddProductButton_Click(sender: System.Object; e: System.EventArgs);
var
  FileUploadOK : boolean;
  errMsg : string;
  FileNameOnServer : string;
  fi:FileInfo;
  HelperDB : THelperDB;
  CatID: integer;
  OperationOK : boolean;
  OldImageFileName : string;
begin

  if cboCategory.SelectedIndex = 0 then
  begin
    ErrorMessage.Text := 'Product NOT added/updated in the database, please select an existing category!';
    Exit;
  end;

  if Action = ProductAdd then
    FileUploadOK := DoUploadImage(FileNameOnServer, errMsg,'', False)
  else
  begin
    try
      OldImageFileName := ViewState['OldImageFileName'].ToString;
    except
      OldImageFileName:='';
    end;


    if OldImageFileName <> '' then
    begin
      fi := FileInfo.Create(OldImageFileName);
      OldImageFileName := fi.Name;
    end
    else
    begin
      OldImageFileName := '';
    end;
    FileNameOnServer := OldImageFileName;
    FileUploadOK := DoUploadImage(FileNameOnServer, errMsg, OldImageFileName, chkRemoveImage.Checked);
  end;

  if not FileUploadOK then
  begin
    ErrorMessage.Text := errMsg;
    Exit;
  end;

  CatID := Convert.ToInt32(cboCategory.SelectedItem.Value);

  HelperDB := THelperDB.Create;
  if Action = ProductAdd then
  begin
    OperationOK := HelperDB.AddProduct(Server.HtmlEncode(ModelNameTextBox.Text), Server.HtmlEncode(ModelNumberTextBox.Text), UnitCostTextBox.Text, FileNameOnServer, Server.HtmlEncode(DescriptionTextBox.Text), CatID);
  end
  else
  begin
    OperationOK := HelperDB.UpdateProduct(PID, Server.HtmlEncode(ModelNameTextBox.Text), Server.HtmlEncode(ModelNumberTextBox.Text), UnitCostTextBox.Text, FileNameOnServer, Server.HtmlEncode(DescriptionTextBox.Text),CatID);
  end;

  if not OperationOK then
    ErrorMessage.Text := 'Product NOT added/updated in the database, some error occured!'
  else
    Response.Redirect('~/default.aspx?action=products&pcid=' + cboCategory.SelectedIndex.ToString);





end;

function TucAddProduct.DoUploadImage(var FileSavedName, ErrorMessage : string; const OldImageName : string; const RemoveExistingImage : boolean): boolean;
const
  MaxSize = 1024 * 1024; // 1 Mb
  thumbWidth=100;
  thumbHeight=75;
var
  FileNameOnServer : string;
  fi : FileInfo;

  function AllowedFileExtension(const ext : string) : boolean;
  begin
    if (ext.IndexOf('.gif') = -1) AND
        (ext.IndexOf('.bmp') = -1) AND
        (ext.IndexOf('.jpg') = -1) AND
        (ext.IndexOf('.jpeg') = -1) AND
        (ext.IndexOf('.png') = -1) THEN
        Result := False
    else
      Result := True;
  end;

  function GetUniqueFileName(fileName:string):string;
  begin
    while System.IO.File.Exists(Path.Combine(THelper.ImagesPath, fileName)) do
      fileName := '_' + fileName;

    Result := Path.Combine(THelper.ImagesPath, fileName);
  end;

begin
  //remove if "remove"
  if (RemoveExistingImage) AND (OldImageName <> '') then
  begin
    FileSavedName := '';
    System.IO.File.Delete(Path.Combine(THelper.ImagesPath, OldImageName));
    System.IO.File.Delete(Path.Combine(THelper.ImagesThumbsPath, OldImageName));
  end;

	if (Assigned(ImageFile.PostedFile)) AND (ImageFile.PostedFile.ContentLength>0) then
	begin
    if ImageFile.PostedFile.ContentLength>MaxSize then
    begin
      ErrorMessage := 'File too big (' + ImageFile.PostedFile.ContentLength.ToString + ' b), max file size 1 Mb.';
      Result := False;
      Exit;
    end;

    fi := FileInfo.Create(ImageFile.PostedFile.FileName);

    if not AllowedFileExtension(fi.Extension) then
    begin
      ErrorMessage := 'Unsupported file extension! Only .gif, .jpg, .jpeg, .png, .bmp allowed!';
      Result := False;
      Exit;
    end;

    FileNameOnServer := GetUniqueFileName(fi.Name);

 		try
      //save new file
    	ImageFile.PostedFile.SaveAs(FileNameOnServer);
      fi := FileInfo.Create(FileNameOnServer);
      FileSavedName := fi.Name;

      GenerateThumbNail(FileSavedName, ImageFile.PostedFile.InputStream, thumbWidth, thumbHeight);

      //remove anyway - since we have a new image
      if (OldImageName <> '') then System.IO.File.Delete(Path.Combine(THelper.ImagesPath, OldImageName));
      if (OldImageName <> '') then System.IO.File.Delete(Path.Combine(THelper.ImagesThumbsPath, OldImageName));

			Result:=true;
		except
			on E:exception do
			begin
				ErrorMessage:=E.Message;
				Result:=False;
			end;
		end;
	end
  else
  begin
    ErrorMessage := 'Image not provided (not an error).';
    Result:=True;
  end;
end;

procedure TucAddProduct.GenerateThumbNail(const FileName : string; const ImageStream : Stream; const tWidth, tHeight : Double);
var
  g : System.Drawing.Image;
  thumbSize : Size;
  imgOutput : Bitmap;
  imgStream : MemoryStream;
begin
//This function creates the Thumbnail image and returns the
//image created in Byte() format

  g := System.Drawing.Image.FromStream(ImageStream);
  thumbSize := NewThumbSize(g.Width, g.Height, tWidth, tHeight);

  imgOutput := Bitmap.Create(g, thumbSize.Width, thumbSize.Height);
  imgStream := MemoryStream.Create;
  imgOutput.Save(imgStream, g.RawFormat);
  imgOutput.Save(Path.Combine(THelper.ImagesThumbsPath,FileName));
  g.Dispose;
  imgOutput.Dispose;
end;


function TucAddProduct.NewThumbSize(const currentwidth, currentheight, newWidth, newHeight : Double) : Size;
var
  tempMultiplier : Double;
  NewSize : Size;
begin
  if currentheight > currentwidth Then
   tempMultiplier := newHeight / currentheight
  else
   tempMultiplier := newWidth / currentwidth;

  NewSize := Size.Create(Convert.ToInt32(currentwidth * tempMultiplier), Convert.ToInt32(currentheight * tempMultiplier));
  Result := NewSize;
end;
end.
